<?php
/*--------------------------------------------------------------------------------------------------
    ProductDownloadServiceProvider.php 2021-09-30
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2021 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Modules\ProductDownload;

use Doctrine\DBAL\Connection;
use Gambio\Admin\Layout\Menu\AdminMenuService;
use Gambio\Admin\Modules\Option\Services\OptionFactory;
use Gambio\Admin\Modules\Option\Services\OptionReadService as OptionReadServiceInterface;
use Gambio\Admin\Modules\Price\Services\ProductPriceConversionService;
use Gambio\Admin\Modules\ProductDownload\App\Actions\Json\CreateProductDownloadsAction;
use Gambio\Admin\Modules\ProductDownload\App\Actions\Json\DeleteSpecificProductDownloadAction;
use Gambio\Admin\Modules\ProductDownload\App\Actions\Json\FetchAllAvailableOptionsAction;
use Gambio\Admin\Modules\ProductDownload\App\Actions\Json\FetchAllProductDownloadsAction;
use Gambio\Admin\Modules\ProductDownload\App\Actions\Json\FetchSpecificAvailableOptionsAction;
use Gambio\Admin\Modules\ProductDownload\App\Actions\Json\FetchSpecificProductDownloadAction;
use Gambio\Admin\Modules\ProductDownload\App\Actions\Json\UpdateProductDownloadsAction;
use Gambio\Admin\Modules\ProductDownload\App\Actions\Vue\IndexAction;
use Gambio\Admin\Modules\ProductDownload\App\Data\Filter\ProductDownloadFilterFactory;
use Gambio\Admin\Modules\ProductDownload\App\Data\ProductDownloadDeleter;
use Gambio\Admin\Modules\ProductDownload\App\Data\ProductDownloadInserter;
use Gambio\Admin\Modules\ProductDownload\App\Data\ProductDownloadMapper;
use Gambio\Admin\Modules\ProductDownload\App\Data\ProductDownloadReader;
use Gambio\Admin\Modules\ProductDownload\App\Data\ProductDownloadUpdater;
use Gambio\Admin\Modules\ProductDownload\App\ProductDownloadFilterService;
use Gambio\Admin\Modules\ProductDownload\App\ProductDownloadReadService;
use Gambio\Admin\Modules\ProductDownload\App\ProductDownloadRepository;
use Gambio\Admin\Modules\ProductDownload\App\ProductDownloadsImageListOperationPermitter;
use Gambio\Admin\Modules\ProductDownload\App\ProductDownloadsOptionOperationPermitter;
use Gambio\Admin\Modules\ProductDownload\App\ProductDownloadWriteService;
use Gambio\Admin\Modules\ProductDownload\Services\ProductDownloadFactory;
use Gambio\Admin\Modules\ProductDownload\Services\ProductDownloadFilterService as ProductDownloadFilterServiceInterface;
use Gambio\Admin\Modules\ProductDownload\Services\ProductDownloadReadService as ProductDownloadReadServiceInterface;
use Gambio\Admin\Modules\ProductDownload\Services\ProductDownloadRepository as ProductDownloadRepositoryInterface;
use Gambio\Admin\Modules\ProductDownload\Services\ProductDownloadWriteService as ProductDownloadWriteServiceInterface;
use Gambio\Admin\Modules\ProductVariant\Services\ProductVariantsReadService as ProductVariantsReadServiceInterface;
use Gambio\Api\Modules\ProductDownload\App\ProductDownloadApiRequestParser;
use Gambio\Api\Modules\ProductDownload\App\ProductDownloadApiRequestValidator;
use Gambio\Core\Application\DependencyInjection\AbstractServiceProvider;
use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Core\Configuration\Services\ConfigurationFinder;
use Gambio\Core\Language\Services\LanguageService;
use Psr\EventDispatcher\EventDispatcherInterface;

/**
 *
 */
class ProductDownloadServiceProvider extends AbstractServiceProvider
{
    
    /**
     * @return string[]
     */
    public function provides(): array
    {
        return [
            IndexAction::class,
            DeleteSpecificProductDownloadAction::class,
            FetchSpecificProductDownloadAction::class,
            UpdateProductDownloadsAction::class,
            CreateProductDownloadsAction::class,
            FetchAllProductDownloadsAction::class,
            FetchAllAvailableOptionsAction::class,
            FetchSpecificAvailableOptionsAction::class,
            ProductDownloadFilterServiceInterface::class,
            ProductDownloadWriteServiceInterface::class,
            ProductDownloadReadServiceInterface::class,
        ];
    }
    
    
    /**
     * @inheritcDoc
     */
    public function register(): void
    {
        $this->application->registerShared(IndexAction::class)
            ->addArgument(Connection::class)
            ->addArgument(UserPreferences::class)
            ->addArgument(AdminMenuService::class)
            ->addArgument(LanguageService::class)
            ->addArgument(ConfigurationFinder::class);
        
        $this->application->registerShared(ProductDownloadFactory::class);
        $this->application->registerShared(ProductDownloadFilterFactory::class);
        $this->application->registerShared(ProductDownloadMapper::class)->addArgument(ProductDownloadFactory::class);
        $this->application->registerShared(ProductDownloadReader::class)->addArgument(Connection::class);
        $this->application->registerShared(ProductDownloadDeleter::class)->addArgument(Connection::class);
        $this->application->registerShared(ProductDownloadInserter::class)->addArgument(Connection::class);
        $this->application->registerShared(ProductDownloadUpdater::class)->addArgument(Connection::class);
        
        $this->application->registerShared(ProductDownloadRepositoryInterface::class, ProductDownloadRepository::class)
            ->addArgument(ProductDownloadMapper::class)
            ->addArgument(ProductDownloadReader::class)
            ->addArgument(ProductDownloadDeleter::class)
            ->addArgument(ProductDownloadInserter::class)
            ->addArgument(ProductDownloadUpdater::class)
            ->addArgument(EventDispatcherInterface::class);
        
        $this->application->registerShared(ProductDownloadFilterServiceInterface::class,
                                           ProductDownloadFilterService::class)
            ->addArgument(ProductDownloadFilterFactory::class)
            ->addArgument(ProductDownloadRepositoryInterface::class)
            ->addArgument(ProductDownloadFactory::class);
        
        $this->application->registerShared(ProductDownloadWriteServiceInterface::class,
                                           ProductDownloadWriteService::class)
            ->addArgument(ProductDownloadRepositoryInterface::class)
            ->addArgument(ProductDownloadFactory::class);
        
        $this->application->registerShared(ProductDownloadReadServiceInterface::class,
                                           ProductDownloadReadService::class)
            ->addArgument(ProductDownloadRepositoryInterface::class)
            ->addArgument(ProductDownloadFactory::class);
        
        $this->application->registerShared(ProductDownloadsOptionOperationPermitter::class)
            ->addArgument(ProductDownloadReader::class);
        
        $this->application->registerShared(ProductDownloadsImageListOperationPermitter::class)
            ->addArgument(ProductDownloadReader::class);
        
        $this->application->registerShared(DeleteSpecificProductDownloadAction::class)
            ->addArgument(ProductDownloadWriteServiceInterface::class)
            ->addArgument(ProductDownloadReadServiceInterface::class);
        
        $this->application->registerShared(FetchSpecificProductDownloadAction::class)
            ->addArgument(ProductDownloadReadServiceInterface::class)
            ->addArgument(OptionReadServiceInterface::class)
            ->addArgument(OptionFactory::class)
            ->addArgument(Connection::class)
            ->addArgument(ProductPriceConversionService::class);
        
        $this->application->registerShared(UpdateProductDownloadsAction::class)
            ->addArgument(ProductDownloadFactory::class)
            ->addArgument(ProductDownloadReadServiceInterface::class)
            ->addArgument(ProductDownloadWriteServiceInterface::class)
            ->addArgument(Connection::class)
            ->addArgument(ProductPriceConversionService::class);
        
        $this->application->registerShared(ProductDownloadApiRequestParser::class)
            ->addArgument(ProductDownloadFactory::class);
        $this->application->registerShared(ProductDownloadApiRequestValidator::class);
        
        $this->application->registerShared(CreateProductDownloadsAction::class)
            ->addArgument(ProductDownloadApiRequestValidator::class)
            ->addArgument(ProductDownloadApiRequestParser::class)
            ->addArgument(ProductDownloadWriteServiceInterface::class)
            ->addArgument(ProductDownloadReadServiceInterface::class)
            ->addArgument(Connection::class)
            ->addArgument(OptionReadServiceInterface::class)
            ->addArgument(ProductPriceConversionService::class);
        
        $this->application->registerShared(FetchAllProductDownloadsAction::class)
            ->addArgument(ProductDownloadReadServiceInterface::class)
            ->addArgument(OptionReadServiceInterface::class)
            ->addArgument(OptionFactory::class)
            ->addArgument(Connection::class)
            ->addArgument(ProductPriceConversionService::class);
        
        $this->application->registerShared(FetchAllAvailableOptionsAction::class)
            ->addArgument(OptionReadServiceInterface::class)
            ->addArgument(ProductDownloadReadServiceInterface::class)
            ->addArgument(ProductVariantsReadServiceInterface::class);
        
        $this->application->registerShared(FetchSpecificAvailableOptionsAction::class)
            ->addArgument(OptionReadServiceInterface::class)
            ->addArgument(ProductDownloadReadServiceInterface::class)
            ->addArgument(ProductVariantsReadServiceInterface::class);
    }
}